define([
    'underscore',
    'backbone',
    'marionette',
    'modules/new-appointment-request/resources/common/city-state/collection',
    'modules/new-appointment-request/views/common/scheduling-steps/heading-view',
    'modules/new-appointment-request/views/common/city-state/section-view',
    'text!modules/new-appointment-request/views/common/scheduling-steps/templates/step-region.html',
], function(_, Backbone, Mn, Collection, HeadingView, BodyView, template) {
    'use strict';

    var View = Mn.View.extend({
        template: _.template(template),

        regions: {
            heading: '.step-heading',
            section: '.step-section',
        },

        initialize: function() {
            this.collection = new Collection();
            this.listenTo(this.collection, 'fetch:success', this.showRegions);
            this.collection.fetch();
        },

        showRegions: function() {
            this.showHeading();
            this.showBody();
        },

        /**
         * @return {void}
         */
        showHeading: function() {
            var region = this.getRegion('heading');
            var model = new Backbone.Model({
                title: View.TITLE,
                number: View.STEP_NUMBER,
                instructions: '',
            });

            region.show(new HeadingView({model: model}));
        },

        showBody: function() {
            var region = this.getRegion('section');
            region.show(new BodyView({
                model: this.model,
                collection: this.collection,
            }));
        },
    });


    View.TITLE = 'City, State';
    View.STEP_NUMBER = 2;

    return View;
});

